<?php $people_team = get_sub_field('show_people_team');

if ($people_team and get_sub_field('people_type') == 'post_object') { ?>

	<div id="carousel-people" class="carousel slide row people-box wow fadeIn" data-wow-delay="500ms" data-ride="carousel">
		<div class="col-sm-16 col-sm-offset-4">
			<div class="carousel-inner people" role="listbox">
				<?php $c = 0;$delay = 50;
				foreach( $people_team as $post) { // variable must be called $post (IMPORTANT)
					setup_postdata($post); ?>
					<div class="item<?php if ($c == 0) echo ' active'; ?>">
						<?php if (has_post_thumbnail()) { ?>
							<div class="col-sm-8 people-image omega hidden-xs">
								<div class="people-image-content">
									<?php the_post_thumbnail(); ?>
								</div>
							</div>
							<div class="col-sm-16 people-text-box alpha">
						<?php } else { ?>
							<div class="col-sm-24">
						<?php } ?>
								<div class="people-text">
									<div class="people-text-container">
										<h3><?php the_title(); ?></h3>
										<?php if (get_field('position')) { ?>
											<p class="position"><?php the_field('position'); ?></p>
										<?php } ?>
										<?php if (get_field('phone') or get_field('email')) { ?>
											<p class="people-contact">
												<?php if (get_field('phone')) { ?>
													<a href="tel:<?php the_field('phone'); ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php the_field('phone'); ?></a>
												<?php } ?>
												<?php if (get_field('email')) { ?>
													<a href="mailto:<?php the_field('email'); ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php the_field('email'); ?></a>
												<?php } ?>
											</p>
										<?php } ?>
									</div>
								</div>
							</div>
					</div>					
				<?php //if (count($people_team) == $c+1) break;
				$c++;$delay + 200;
				} ?>
			</div>
			<?php if (count($people_team) > 1) { ?>
				<ol class="carousel-indicators">
					<?php $c = 0;
					foreach( $people_team as $post) {
						setup_postdata($post); ?>
						<li data-target="#carousel-people" data-slide-to="<?php echo $c; ?>"<?php if ($c == 0) { ?> class="active"<?php } ?>></li>
					<?php if (count($people_team) == $c) break;
					$c++;
					} ?>
				</ol>
			<?php } ?>
		</div>
	</div>
	<?php wp_reset_postdata();
	
} elseif (get_sub_field('people_type') == 'repeater' and have_rows('people')) { ?>
	<div id="carousel-people" class="carousel slide row people-box wow fadeIn" data-wow-delay="500ms" data-ride="carousel">
		<div class="col-sm-16 col-sm-offset-4">
			<div class="carousel-inner people" role="listbox">
				<?php $c = 0;$delay = 50;
				while ( have_rows('people') ) { the_row();
					$person_image = get_sub_field('person_image'); ?>
					<div class="item<?php if ($c == 0) echo ' active'; ?>">
						<?php if ($person_image) { ?>
							<div class="col-sm-8 people-image omega hidden-xs">
								<div class="people-image-content">
									<img src="<?php echo $person_image['url']; ?>">
								</div>
							</div>
							<div class="col-sm-16 people-text-box alpha">
						<?php } else { ?>
							<div class="col-sm-24">
						<?php } ?>
								<div class="people-text">
									<div class="people-text-container">
										<?php if (get_sub_field('name')) { ?>
											<h3><?php the_sub_field('name'); ?></h3>
										<?php } ?>
										<?php if (get_sub_field('position')) { ?>
											<p class="position"><?php the_sub_field('position'); ?></p>
										<?php } ?>
										<?php if (get_sub_field('phone') or get_sub_field('email')) { ?>
											<p class="people-contact">
												<?php if (get_sub_field('phone')) { ?>
													<a href="tel:<?php the_sub_field('phone'); ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php the_sub_field('phone'); ?></a>
												<?php } ?>
												<?php if (get_sub_field('email')) { ?>
													<a href="mailto:<?php the_sub_field('email'); ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php the_sub_field('email'); ?></a>
												<?php } ?>
											</p>
										<?php } ?>
									</div>
								</div>
							</div>
					</div>					
				<?php $c++;$delay + 200;
				} ?>
			</div>
			<?php if (count(get_sub_field('people')) > 1) { ?>
				<ol class="carousel-indicators">
					<?php $ca = 0;
					while ( have_rows('people') ) { the_row(); ?>
						<li data-target="#carousel-people" data-slide-to="<?php echo $ca; ?>"<?php if ($ca == 0) { ?> class="active"<?php } ?>></li>
					<?php $ca++;
					} ?>
				</ol>
			<?php } ?>
		</div>
	</div>
<?php } ?>